/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Arrays;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BecomesBasicLandTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class TundraKavuEffect
extends BecomesBasicLandTargetEffect {
    TundraKavuEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "Target land becomes a Plains or an Island until end of turn.";
    }

    private TundraKavuEffect(TundraKavuEffect effect) {
        super((BecomesBasicLandTargetEffect)effect);
    }

    public TundraKavuEffect copy() {
        return new TundraKavuEffect(this);
    }

    protected void chooseLandType(Ability source, Game game) {
        this.landTypes.clear();
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceImpl choice = new ChoiceImpl(true, ChoiceHintType.CARD);
        choice.setChoices(new HashSet<String>(Arrays.asList("Plains", "Island")));
        choice.setMessage("Choose a basic land type");
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game)) {
            this.landTypes.add(SubType.byDescription((String)choice.getChoice()));
        } else {
            this.discard();
        }
    }
}

