/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TuneUpEffect
extends ContinuousEffectImpl {
    TuneUpEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "If it's a Vehicle, it becomes an artifact creature";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TuneUpEffect(TuneUpEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TuneUpEffect copy() {
        return new TuneUpEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.hasSubtype(SubType.VEHICLE, game)) {
            permanent.addCardType(new CardType[]{CardType.CREATURE});
            return true;
        }
        return false;
    }
}

