/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class TurfWoundEffect
extends ContinuousRuleModifyingEffectImpl {
    TurfWoundEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "Target player can't play lands this turn";
    }

    private TurfWoundEffect(TurfWoundEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TurfWoundEffect copy() {
        return new TurfWoundEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't play lands this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getFirstTarget());
    }
}

