/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class TuvasaTheSunlitWatcher
extends Watcher {
    private final Map<UUID, UUID> firstEnchantmentThisTurn = new HashMap<UUID, UUID>();

    public TuvasaTheSunlitWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isEnchantment(game)) {
            this.firstEnchantmentThisTurn.putIfAbsent(event.getPlayerId(), spell.getId());
        }
    }

    public void reset() {
        this.firstEnchantmentThisTurn.clear();
    }

    public UUID getFirstEnchantmentThisTurn(UUID playerId) {
        return this.firstEnchantmentThisTurn.get(playerId);
    }
}

