/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.RoleType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TwistedSewerWitchEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent(SubType.RAT, "Rat you control");

    TwistedSewerWitchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then for each Rat you control, create a Wicked Role token attached to that Rat.";
    }

    private TwistedSewerWitchEffect(TwistedSewerWitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwistedSewerWitchEffect copy() {
        return new TwistedSewerWitchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            RoleType.WICKED.createToken(permanent, game, source);
        }
        return true;
    }
}

