/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.ExploreEvent;
import mage.game.events.GameEvent;

class TwistsAndTurnsReplacementEffect
extends ReplacementEffectImpl {
    TwistsAndTurnsReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature you control would explore, instead you scry 1, then that creature explores";
    }

    private TwistsAndTurnsReplacementEffect(TwistsAndTurnsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TwistsAndTurnsReplacementEffect copy() {
        return new TwistsAndTurnsReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXPLORE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getControllerId().equals(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ExploreEvent exploreEvent = (ExploreEvent)event;
        exploreEvent.addScry();
        return false;
    }
}

