/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.MillCardsControllerEffect;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class TymaretCallsTheDeadFirstEffect
extends OneShotEffect {
    private static final Effect millEffect = new MillCardsControllerEffect(3);
    private static final Effect tokenEffect = new CreateTokenEffect((Token)new ZombieToken());
    private static final FilterCard filter = new FilterCard("creature or enchantment card from your graveyard");

    TymaretCallsTheDeadFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards. Then you may exile a creature or enchantment card from your graveyard. If you do, create a 2/2 black Zombie creature token";
    }

    private TymaretCallsTheDeadFirstEffect(TymaretCallsTheDeadFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public TymaretCallsTheDeadFirstEffect copy() {
        return new TymaretCallsTheDeadFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        millEffect.apply(game, source);
        if (player.getGraveyard().count(filter, game) == 0 || !player.chooseUse(Outcome.Exile, "Exile a creature or enchantment card from your graveyard?", source, game)) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            return true;
        }
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.EXILED, source, game) && tokenEffect.apply(game, source);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

