/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TyrannicalPitlordBoostEffect
extends ContinuousEffectImpl {
    TyrannicalPitlordBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "the chosen creature gets +3/+3";
    }

    private TyrannicalPitlordBoostEffect(TyrannicalPitlordBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TyrannicalPitlordBoostEffect copy() {
        return new TyrannicalPitlordBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object chosenCreature = game.getState().getValue(CardUtil.getCardZoneString((String)"chosenCreature", (UUID)source.getSourceId(), (Game)game));
        if (!(chosenCreature instanceof MageObjectReference)) {
            return false;
        }
        Permanent permanent = ((MageObjectReference)chosenCreature).getPermanent(game);
        if (permanent == null) {
            return false;
        }
        permanent.addPower(3);
        permanent.addToughness(3);
        return true;
    }
}

