/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class TyrantsChoiceEffect
extends OneShotEffect {
    TyrantsChoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Will of the council</i> &mdash; Starting with you, each player votes for death or torture. If death gets more votes, each opponent sacrifices a creature. If torture gets more votes or the vote is tied, each opponent loses 4 life";
    }

    private TyrantsChoiceEffect(TyrantsChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TyrantsChoiceEffect copy() {
        return new TyrantsChoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Death (sacrifice a creature)", "Torture (lose 4 life)", Outcome.Benefit);
        vote.doVotes(source, game, (voteHandler, aiPlayer, aiDecidingPlayer, aiSource, aiGame) -> {
            if (aiSource.isControlledBy(aiDecidingPlayer.getId())) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        int deathCount = vote.getVoteCount((Object)true);
        int tortureCount = vote.getVoteCount((Object)false);
        if (deathCount > tortureCount) {
            return new SacrificeOpponentsEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE).apply(game, source);
        }
        return new LoseLifeOpponentsEffect(4).apply(game, source);
    }
}

