/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class TyvarJubilantBrawlerReturnEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 2 or less from your graveyard");

    TyvarJubilantBrawlerReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may return a creature card with mana value 2 or less from your graveyard to the battlefield";
    }

    private TyvarJubilantBrawlerReturnEffect(TyvarJubilantBrawlerReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public TyvarJubilantBrawlerReturnEffect copy() {
        return new TyvarJubilantBrawlerReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

