/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class NassariDeanOfExpressionEffect
extends OneShotEffect {
    NassariDeanOfExpressionEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each opponent's library. Until end of turn, you may cast spells from among those exiled cards, and you may spend mana as though it were mana of any color to cast those spells";
    }

    private NassariDeanOfExpressionEffect(NassariDeanOfExpressionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NassariDeanOfExpressionEffect copy() {
        return new NassariDeanOfExpressionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getLibrary).map(p -> p.getFromTop(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            return false;
        }
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }
}

