/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.u.UbaMaskExiledCardsWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class UbaMaskPlayEffect
extends AsThoughEffectImpl {
    UbaMaskPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each player may play lands and cast spells from among cards they exiled with {this} this turn";
    }

    private UbaMaskPlayEffect(UbaMaskPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public UbaMaskPlayEffect copy() {
        return new UbaMaskPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UbaMaskExiledCardsWatcher watcher;
        Card card = game.getCard(objectId = CardUtil.getMainCardId((Game)game, (UUID)objectId));
        if (card != null && affectedControllerId.equals(card.getOwnerId()) && game.getState().getZone(card.getId()) == Zone.EXILED && (watcher = (UbaMaskExiledCardsWatcher)game.getState().getWatcher(UbaMaskExiledCardsWatcher.class)) != null) {
            List<MageObjectReference> exiledThisTurn = watcher.getUbaMaskExiledCardsThisTurn(affectedControllerId);
            UUID exileId = CardUtil.getExileZoneId((String)(affectedControllerId + "-" + game.getState().getTurnNum() + "-" + source.getSourceObject(game).getIdName() + "-" + source.getSourceObject(game).getZoneChangeCounter(game)), (Game)game);
            ExileZone exileZone = game.getExile().getExileZone(exileId);
            return exiledThisTurn != null && exiledThisTurn.contains(new MageObjectReference((MageObject)card, game)) && exileZone != null && exileZone.contains((Object)objectId);
        }
        return false;
    }
}

