/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class UginTheSpiritDragonEffect3
extends OneShotEffect {
    public UginTheSpiritDragonEffect3() {
        super(Outcome.Benefit);
        this.staticText = "You gain 7 life, draw seven cards, then put up to seven permanent cards from your hand onto the battlefield";
    }

    private UginTheSpiritDragonEffect3(UginTheSpiritDragonEffect3 effect) {
        super((OneShotEffect)effect);
    }

    public UginTheSpiritDragonEffect3 copy() {
        return new UginTheSpiritDragonEffect3(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(7, game, source);
            controller.drawCards(7, source, game);
            TargetCardInHand target = new TargetCardInHand(0, 7, (FilterCard)new FilterPermanentCard("permanent cards"));
            if (controller.choose(Outcome.PutCardInPlay, (Target)target, source, game)) {
                controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

