/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UkkimaStalkingShadowEffect
extends OneShotEffect {
    UkkimaStalkingShadowEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals X damage to target player and you gain X life, where X is its power.";
    }

    private UkkimaStalkingShadowEffect(UkkimaStalkingShadowEffect effect) {
        super((OneShotEffect)effect);
    }

    public UkkimaStalkingShadowEffect copy() {
        return new UkkimaStalkingShadowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null || permanent.getPower().getValue() <= 0) {
            return false;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            player.damage(permanent.getPower().getValue(), source.getSourceId(), source, game);
        }
        if ((controller = game.getPlayer(source.getControllerId())) != null) {
            controller.gainLife(permanent.getPower().getValue(), game, source);
        }
        return true;
    }
}

