/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class UlamogTheDefilerTargetEffect
extends OneShotEffect {
    UlamogTheDefilerTargetEffect() {
        super(Outcome.Detriment);
        this.staticText = "target opponent exiles half their library, rounded up";
    }

    private UlamogTheDefilerTargetEffect(UlamogTheDefilerTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public UlamogTheDefilerTargetEffect copy() {
        return new UlamogTheDefilerTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        int toExile = (opponent.getLibrary().size() + 1) / 2;
        Set cards = opponent.getLibrary().getTopCards(game, toExile);
        if (cards.isEmpty()) {
            return false;
        }
        opponent.moveCardsToExile(cards, source, game, true, null, "");
        return true;
    }
}

