/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class UltimateMagicMeteorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("artifact or land");

    UltimateMagicMeteorEffect() {
        super(Outcome.Benefit);
        this.staticText = "If this spell was cast from exile, for each opponent, choose an artifact or land that player controls. Destroy the chosen permanents";
    }

    private UltimateMagicMeteorEffect(UltimateMagicMeteorEffect effect) {
        super((OneShotEffect)effect);
    }

    public UltimateMagicMeteorEffect copy() {
        return new UltimateMagicMeteorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!Optional.ofNullable(source).map(Ability::getSourceId).map(arg_0 -> ((Game)game).getSpell(arg_0)).map(Spell::getFromZone).map(arg_0 -> ((Zone)Zone.EXILED).match(arg_0)).orElse(false).booleanValue()) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            FilterPermanent filter = UltimateMagicMeteorEffect.filter.copy();
            Optional.ofNullable(playerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getName).ifPresent(s -> filter.setMessage("artifact or land controlled by " + s));
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            if (!game.getBattlefield().contains(filter, source.getControllerId(), source, game, 1)) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
        }
        for (Permanent permanent : permanents) {
            if (permanent == null) continue;
            permanent.destroy(source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
    }
}

