/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class UltraMagnusTacticianEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterArtifactCard("artifact creature card");

    UltraMagnusTacticianEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put an artifact creature card from your hand onto the battlefield tapped and attacking. If you do, convert {this} at end of combat";
    }

    private UltraMagnusTacticianEffect(UltraMagnusTacticianEffect effect) {
        super((OneShotEffect)effect);
    }

    public UltraMagnusTacticianEffect copy() {
        return new UltraMagnusTacticianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new TransformSourceEffect().setText("convert {this}")), source);
        return true;
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

