/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class UnableToScreamPreventingEffect
extends ContinuousRuleModifyingEffectImpl {
    UnableToScreamPreventingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.setText("As long as enchanted creature is face down, it can't be turned face up.");
    }

    private UnableToScreamPreventingEffect(UnableToScreamPreventingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.TURN_FACE_UP);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura == null) {
            return false;
        }
        Permanent creature = game.getPermanent(aura.getAttachedTo());
        if (creature == null) {
            return false;
        }
        return creature.isFaceDown(game) && event.getTargetId().equals(creature.getId());
    }

    public UnableToScreamPreventingEffect copy() {
        return new UnableToScreamPreventingEffect(this);
    }
}

