/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class UncheckedGrowth
extends CardImpl {
    public UncheckedGrowth(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{G}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(4, 4, Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UncheckedGrowthTrampleEffect());
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
    }

    private UncheckedGrowth(UncheckedGrowth card) {
        super((CardImpl)card);
    }

    public UncheckedGrowth copy() {
        return new UncheckedGrowth(this);
    }

    private static class UncheckedGrowthTrampleEffect
    extends ContinuousEffectImpl {
        public UncheckedGrowthTrampleEffect() {
            super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
            this.staticText = "If it's a Spirit, it gains trample until end of turn";
        }

        private UncheckedGrowthTrampleEffect(UncheckedGrowthTrampleEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public UncheckedGrowthTrampleEffect copy() {
            return new UncheckedGrowthTrampleEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            int affectedTargets = 0;
            for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null || !permanent.hasSubtype(SubType.SPIRIT, game)) continue;
                permanent.addAbility((Ability)TrampleAbility.getInstance(), source.getSourceId(), game);
                ++affectedTargets;
            }
            return affectedTargets > 0;
        }
    }
}

