/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class UnexpectedlyAbsentEffect
extends OneShotEffect {
    UnexpectedlyAbsentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target nonland permanent into its owner's library just beneath the top X cards of that library";
    }

    private UnexpectedlyAbsentEffect(UnexpectedlyAbsentEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnexpectedlyAbsentEffect copy() {
        return new UnexpectedlyAbsentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            controller.putCardOnTopXOfLibrary((Card)permanent, game, source, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1, true);
            return true;
        }
        return false;
    }
}

