/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class UnfinishedBusinessEffect
extends OneShotEffect {
    UnfinishedBusinessEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield, then return up to two target Aura and/or Equipment cards from your graveyard to the battlefield attached to that creature. <i>(If the Auras can not enchant that creature, they remain in your graveyard.)</i>";
    }

    private UnfinishedBusinessEffect(UnfinishedBusinessEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card targetCreature = game.getCard(source.getTargets().getFirstTarget());
        if (targetCreature != null) {
            controller.moveCards(targetCreature, Zone.BATTLEFIELD, source, game);
            game.processAction();
        }
        Permanent permanentCreature = targetCreature == null ? null : game.getPermanent(targetCreature.getId());
        CardsImpl cardsInitial = new CardsImpl((Collection)((Target)source.getTargets().get(1)).getTargets());
        if (cardsInitial.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID c : cardsInitial) {
            if (game.getCard(c).hasSubtype(SubType.EQUIPMENT, game)) {
                cards.add((Object)c);
                continue;
            }
            if (permanentCreature == null || permanentCreature.cantBeAttachedBy((MageObject)game.getCard(c), source, game, false) || !game.getCard(c).hasSubtype(SubType.AURA, game)) continue;
            cards.add((Object)c);
        }
        if (cards.isEmpty()) {
            return false;
        }
        if (permanentCreature != null) {
            cards.getCards(game).forEach(card -> {
                Permanent cfr_ignored_0 = (Permanent)game.getState().setValue("attachTo:" + card.getId(), (Object)permanentCreature);
            });
        }
        controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        if (permanentCreature != null) {
            for (UUID id : cards) {
                if (permanentCreature.cantBeAttachedBy((MageObject)game.getCard(id), source, game, true)) continue;
                permanentCreature.addAttachment(id, source, game);
            }
        }
        return true;
    }

    public UnfinishedBusinessEffect copy() {
        return new UnfinishedBusinessEffect(this);
    }
}

