/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class UnholyIndentureReturnEffect
extends OneShotEffect {
    UnholyIndentureReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return that card to the battlefield under your control with a +1/+1 counter on it";
    }

    private UnholyIndentureReturnEffect(UnholyIndentureReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnholyIndentureReturnEffect copy() {
        return new UnholyIndentureReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Object object = this.getValue("attachedTo");
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && object instanceof Permanent && !(object instanceof PermanentToken) && (card = game.getCard(((Permanent)object).getId())) != null && card.getZoneChangeCounter(game) == ((Permanent)object).getZoneChangeCounter(game) + 1) {
            Counters countersToAdd = new Counters(new Counter[0]);
            countersToAdd.addCounter(CounterType.P1P1.createInstance());
            game.setEnterWithCounters(card.getId(), countersToAdd);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
            return true;
        }
        return false;
    }
}

