/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.PutCards;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class UnityOfTheDroids
extends CardImpl {
    private static final FilterCreaturePermanent artifactCreatureFilter = new FilterCreaturePermanent("artifact creature");
    private static final FilterCreaturePermanent nonArtifactCreatureFilter = new FilterCreaturePermanent("nonartifact creature");

    public UnityOfTheDroids(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{W}{U}{B}");
        this.getSpellAbility().addEffect((Effect)new PreventDamageToTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)artifactCreatureFilter));
        Mode mode = new Mode((Effect)new LookLibraryAndPickControllerEffect(4, 1, PutCards.HAND, PutCards.GRAVEYARD));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)nonArtifactCreatureFilter));
        this.getSpellAbility().addMode(mode);
    }

    private UnityOfTheDroids(UnityOfTheDroids card) {
        super((CardImpl)card);
    }

    public UnityOfTheDroids copy() {
        return new UnityOfTheDroids(this);
    }

    static {
        artifactCreatureFilter.add((Predicate)CardType.ARTIFACT.getPredicate());
        nonArtifactCreatureFilter.add(Predicates.not((Predicate)CardType.ARTIFACT.getPredicate()));
    }
}

