/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnleashFuryEffect
extends OneShotEffect {
    UnleashFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power of target creature until end of turn";
    }

    private UnleashFuryEffect(UnleashFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnleashFuryEffect copy() {
        return new UnleashFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(permanent.getPower().getValue(), 0, Duration.EndOfTurn), source);
        return true;
    }
}

