/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Cards;
import mage.cards.u.UnluckyWitnessWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class UnluckyWitnessPlayEffect
extends AsThoughEffectImpl {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    UnluckyWitnessPlayEffect(Cards cards, Game game) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.UntilYourNextEndStep, Outcome.Benefit);
        cards.stream().map(uuid -> new MageObjectReference(uuid, game)).forEach(this.morSet::add);
    }

    private UnluckyWitnessPlayEffect(UnluckyWitnessPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.morSet.addAll(effect.morSet);
    }

    public UnluckyWitnessPlayEffect copy() {
        return new UnluckyWitnessPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        UUID objectIdToCast = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        return source.isControlledBy(affectedControllerId) && this.morSet.stream().anyMatch(mor -> mor.refersTo(objectIdToCast, game)) && UnluckyWitnessWatcher.checkRef(source, this.morSet, game);
    }
}

