/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class UnmarkedGraveEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard("nonlegendary card");

    public UnmarkedGraveEffect() {
        super(new TargetCardInLibrary(filter), Outcome.Neutral);
        this.staticText = "search your library for a nonlegendary card, put that card into your graveyard, then shuffle";
    }

    private UnmarkedGraveEffect(UnmarkedGraveEffect effect) {
        super((SearchEffect)effect);
    }

    public UnmarkedGraveEffect copy() {
        return new UnmarkedGraveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            controller.moveCards(game.getCard(this.target.getFirstTarget()), Zone.GRAVEYARD, source, game);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
    }
}

