/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class UrabraskHereticPraetorEffect
extends ReplacementEffectImpl {
    UrabraskHereticPraetorEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "the next time they would draw a card this turn, instead they exile the top card of their library. They may play it this turn";
    }

    private UrabraskHereticPraetorEffect(UrabraskHereticPraetorEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.isActivePlayer(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            this.discard();
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false, (UUID)player.getId(), null);
        }
        this.discard();
        return true;
    }

    public UrabraskHereticPraetorEffect copy() {
        return new UrabraskHereticPraetorEffect(this);
    }
}

