/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.PhyrexianHorrorRedToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class UrabrasksForgeEffect
extends OneShotEffect {
    UrabrasksForgeEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then create an X/1 red Phyrexian Horror creature token with trample and haste, where X is the number of oil counters on {this}. Sacrifice that token at the beginning of the next end step";
    }

    private UrabrasksForgeEffect(UrabrasksForgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrabrasksForgeEffect copy() {
        return new UrabrasksForgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(permanent -> permanent.getCounters(game)).map(counters -> counters.getCount(CounterType.OIL)).orElse(0);
        PhyrexianHorrorRedToken token = new PhyrexianHorrorRedToken(amount);
        token.putOntoBattlefield(1, game, source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect().setText("sacrifice it").setTargetPointer((TargetPointer)new FixedTargets((Token)token, game))), source);
        return true;
    }
}

