/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class UrborgSyphonMageEffect
extends OneShotEffect {
    UrborgSyphonMageEffect() {
        super(Outcome.Damage);
        this.staticText = "Each other player loses 2 life. You gain life equal to the life lost this way";
    }

    private UrborgSyphonMageEffect(UrborgSyphonMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damage = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (source.isControlledBy(playerId) || (player = game.getPlayer(playerId)) == null) continue;
                damage += player.loseLife(2, game, source, false);
            }
            game.getPlayer(source.getControllerId()).gainLife(damage, game, source);
            return true;
        }
        return false;
    }

    public UrborgSyphonMageEffect copy() {
        return new UrborgSyphonMageEffect(this);
    }
}

