/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.ControllerLifeCount;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.dynamicvalue.common.PermanentsTargetOpponentControlsCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageAllControlledTargetEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DestroyAllControlledTargetEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ExileFromZoneTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.GetEmblemEffect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.RevealLibraryPutIntoHandEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.abilities.effects.common.ShuffleHandGraveyardAllEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.DistributeCountersEffect;
import mage.abilities.effects.common.discard.DiscardControllerEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.effects.common.turn.ControlTargetPlayerNextTurnEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardSetInfo;
import mage.cards.c.ChandraFlamecaller;
import mage.cards.g.GarrukApexPredator;
import mage.cards.g.GideonJura;
import mage.cards.j.JaceArchitectOfThought;
import mage.cards.j.JaceTheMindSculptor;
import mage.cards.l.LilianaVess;
import mage.cards.n.NissaSageAnimist;
import mage.cards.n.NissaWorldwaker;
import mage.cards.r.RalZarek;
import mage.cards.s.SarkhanTheDragonspeaker;
import mage.cards.s.SarkhanUnbroken;
import mage.cards.s.SorinLordOfInnistrad;
import mage.cards.s.SorinMarkov;
import mage.cards.u.UginTheSpiritDragonEffect3;
import mage.cards.u.UrzaAcademyHeadmasterBrainstormEffect;
import mage.cards.u.UrzaAcademyHeadmasterManaEffect;
import mage.cards.v.VraskaTheUnseen;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.command.emblems.AjaniSteadfastEmblem;
import mage.game.command.emblems.DomriRadeEmblem;
import mage.game.command.emblems.ElspethKnightErrantEmblem;
import mage.game.command.emblems.GideonAllyOfZendikarEmblem;
import mage.game.command.emblems.KioraMasterOfTheDepthsEmblem;
import mage.game.command.emblems.VenserTheSojournerEmblem;
import mage.game.permanent.token.AssassinToken;
import mage.game.permanent.token.BeastToken;
import mage.game.permanent.token.CatToken;
import mage.game.permanent.token.DemonToken;
import mage.game.permanent.token.DragonTokenGold;
import mage.game.permanent.token.GarrukApexPredatorBeastToken;
import mage.game.permanent.token.OctopusToken;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WurmToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.common.TargetAnyTarget;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetCreaturePermanentAmount;
import mage.target.common.TargetNonlandPermanent;
import mage.target.common.TargetOpponent;
import mage.target.common.TargetPlayerOrPlaneswalker;
import mage.util.RandomUtil;

class UrzaAcademyHeadmasterRandomEffect
extends OneShotEffect {
    private int selection;
    private CardSetInfo setInfo;
    private static final FilterCreaturePermanent filter1 = new FilterCreaturePermanent("creatures you control");
    private static final FilterPermanent filter2 = new FilterPermanent("noncreature permanent");
    private static final FilterCard filter3 = new FilterCard("creature and/or land cards");
    private static final FilterPermanent filter4 = new FilterPermanent("creatures and/or planeswalkers");

    public UrzaAcademyHeadmasterRandomEffect(int selection, CardSetInfo setInfo) {
        super(Outcome.Neutral);
        this.selection = selection;
        this.setInfo = setInfo.copy();
        switch (selection) {
            case 1: {
                this.staticText = "Head to AskUrza.com and click +1";
                break;
            }
            case 2: {
                this.staticText = "Head to AskUrza.com and click -1";
                break;
            }
            case 3: {
                this.staticText = "Head to AskUrza.com and click -6";
            }
        }
    }

    private UrzaAcademyHeadmasterRandomEffect(UrzaAcademyHeadmasterRandomEffect effect) {
        super((OneShotEffect)effect);
        this.selection = effect.selection;
        this.setInfo = effect.setInfo.copy();
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetPermanent target;
            ArrayList<Object> effects;
            block76: {
                int result = RandomUtil.nextInt((int)20) + 1;
                effects = new ArrayList<Object>();
                target = null;
                StringBuilder sb = new StringBuilder("[URZA] ");
                while (true) {
                    block0 : switch (this.selection) {
                        case 1: {
                            switch (result) {
                                case 1: {
                                    sb.append("Until end of turn, up to one target creature gets +1/+1 and gains first strike, vigilance, and lifelink.");
                                    effects.add(new BoostTargetEffect(1, 1, Duration.EndOfTurn));
                                    effects.add(new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn));
                                    effects.add(new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn));
                                    effects.add(new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn));
                                    target = new TargetCreaturePermanent(0, 1);
                                    break;
                                }
                                case 2: {
                                    sb.append("Distribute three +1/+1 counters among one, two, or three target creatures you control.");
                                    effects.add(new DistributeCountersEffect());
                                    target = new TargetCreaturePermanentAmount(3, filter1);
                                    break;
                                }
                                case 3: {
                                    sb.append("Destroy target noncreature permanent.");
                                    effects.add(new DestroyTargetEffect());
                                    target = new TargetPermanent(filter2);
                                    break;
                                }
                                case 4: {
                                    sb.append("Create two 3/1 red Elemental creature tokens with haste. Exile them at the beginning of the next end step.");
                                    effects.add(((Ability)new ChandraFlamecaller(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 5: {
                                    sb.append("Create three 1/1 white Soldier creature tokens.");
                                    effects.add(new CreateTokenEffect((Token)new SoldierToken(), 3));
                                    break;
                                }
                                case 6: {
                                    sb.append("Create a 3/3 black Beast creature token with deathtouch.");
                                    effects.add(new CreateTokenEffect((Token)new GarrukApexPredatorBeastToken()));
                                    break;
                                }
                                case 7: {
                                    sb.append("Reveal the top five cards of your library. Put all creature cards revealed this way into your hand and the rest on the bottom of your library in any order.");
                                    effects.add(new RevealLibraryPutIntoHandEffect(5, (FilterCard)new FilterCreatureCard("creature cards"), Zone.LIBRARY));
                                    break;
                                }
                                case 8: {
                                    sb.append("During target opponent's next turn, creatures that player controls attack Urza if able.");
                                    effects.add(((Ability)new GideonJura(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    target = new TargetOpponent();
                                    break;
                                }
                                case 9: {
                                    sb.append("Put a loyalty counter on Urza for each creature target opponent controls.");
                                    effects.add(new AddCountersSourceEffect(CounterType.LOYALTY.createInstance(0), (DynamicValue)new PermanentsTargetOpponentControlsCount((FilterPermanent)new FilterCreaturePermanent()), true));
                                    target = new TargetOpponent();
                                    break;
                                }
                                case 10: {
                                    sb.append("Until your next turn, whenever a creature an opponent controls attacks, it gets -1/-0 until end of turn.");
                                    effects.add(((Ability)new JaceArchitectOfThought(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 11: {
                                    sb.append("Target player exiles a card from their hand.");
                                    effects.add(new ExileFromZoneTargetEffect(Zone.HAND, true));
                                    target = new TargetPlayer();
                                    break;
                                }
                                case 12: {
                                    sb.append("Reveal the top card of your library. If it's a land card, put it onto the battlefield. Otherwise, put it into your hand.");
                                    effects.add(((Ability)new NissaSageAnimist(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 13: {
                                    sb.append("Target land you control becomes a 4/4 Elemental creature with trample. It's still a land.");
                                    effects.add(((Ability)new NissaWorldwaker(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    target = new TargetPermanent((FilterPermanent)new FilterControlledLandPermanent());
                                    break;
                                }
                                case 14: {
                                    sb.append("Draw a card, then add one mana of any color to your mana pool.");
                                    effects.add(((Ability)new SarkhanUnbroken(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 15: {
                                    sb.append("Until end of turn, Urza becomes a legendary 4/4 red Dragon creature with flying, indestructible, and haste. (He doesn't lose loyalty while he's not a planeswalker.)");
                                    effects.add(((Ability)new SarkhanTheDragonspeaker(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 16: {
                                    sb.append("Until your next turn, creatures you control get +1/+0 and gain lifelink.");
                                    effects.add(new BoostControlledEffect(1, 0, Duration.UntilYourNextTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES));
                                    effects.add(new GainAbilityControlledEffect((Ability)LifelinkAbility.getInstance(), Duration.UntilYourNextTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES));
                                    break;
                                }
                                case 17: {
                                    sb.append("Look at the top five cards of your library. You may reveal an artifact card from among them and put it into your hand. Put the rest on the bottom of your library in any order.");
                                    effects.add(new LookLibraryAndPickControllerEffect(5, 1, (FilterCard)StaticFilters.FILTER_CARD_ARTIFACT_AN, PutCards.HAND, PutCards.BOTTOM_ANY));
                                    break;
                                }
                                case 18: {
                                    sb.append("Urza deals 3 damage to any target.");
                                    effects.add(new DamageTargetEffect(3));
                                    target = new TargetAnyTarget();
                                    break;
                                }
                                case 19: {
                                    sb.append("Until your next turn, whenever a creature deals combat damage to Urza, destroy that creature.");
                                    effects.add(((Ability)new VraskaTheUnseen(controller.getId(), this.setInfo).getAbilities().get(2)).getEffects().get(0));
                                    break;
                                }
                                case 20: {
                                    sb.append("Add X mana in any combination of colors to your mana pool, where X is the number of creatures you control.");
                                    effects.add((Object)new UrzaAcademyHeadmasterManaEffect());
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (result) {
                                case 1: {
                                    sb.append("Urza deals 3 damage to each creature.");
                                    effects.add(new DamageAllEffect(3, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE));
                                    break;
                                }
                                case 2: {
                                    sb.append("Gain control of target creature.");
                                    effects.add(new GainControlTargetEffect(Duration.Custom));
                                    target = new TargetCreaturePermanent();
                                    break;
                                }
                                case 3: {
                                    sb.append("Urza deals 4 damage to target creature or player and you gain 4 life.");
                                    effects.add(new DamageTargetEffect(4));
                                    effects.add(new GainLifeEffect(4));
                                    target = new TargetAnyTarget();
                                    break;
                                }
                                case 4: {
                                    sb.append("Destroy target creature. You gain life equal to its toughness.");
                                    effects.add(new DestroyTargetEffect());
                                    effects.add(((Ability)new GarrukApexPredator(controller.getId(), this.setInfo).getAbilities().get(4)).getEffects().get(1));
                                    target = new TargetCreaturePermanent();
                                    break;
                                }
                                case 5: {
                                    sb.append("You get an emblem with \u201cCreatures you control get +1/+1.\u201d");
                                    effects.add(new GetEmblemEffect((Emblem)new GideonAllyOfZendikarEmblem()));
                                    break;
                                }
                                case 6: {
                                    sb.append("You may put a creature card from your hand onto the battlefield.");
                                    effects.add(new PutCardFromHandOntoBattlefieldEffect((FilterCard)StaticFilters.FILTER_CARD_CREATURE));
                                    break;
                                }
                                case 7: {
                                    sb.append("Draw three cards, then put a card from your hand on top of your library.");
                                    effects.add((Object)new UrzaAcademyHeadmasterBrainstormEffect());
                                    break;
                                }
                                case 8: {
                                    sb.append("Target player mills ten cards.");
                                    effects.add(new MillCardsTargetEffect(10));
                                    target = new TargetPlayer();
                                    break;
                                }
                                case 9: {
                                    sb.append("Reveal the top five cards of your library. An opponent separates those cards into two piles. Put one pile into your hand and the other on the bottom of your library in any order.");
                                    effects.add(((Ability)new JaceArchitectOfThought(controller.getId(), this.setInfo).getAbilities().get(3)).getEffects().get(0));
                                    break;
                                }
                                case 10: {
                                    sb.append("Exile target permanent.");
                                    effects.add(new ExileTargetEffect());
                                    target = new TargetPermanent();
                                    break;
                                }
                                case 11: {
                                    sb.append("Reveal the top five cards of your library. You may put all creature cards and/or land cards from among them into your hand. Put the rest into your graveyard.");
                                    effects.add(new RevealLibraryPutIntoHandEffect(5, filter3, Zone.LIBRARY));
                                    break;
                                }
                                case 12: {
                                    sb.append("Search your library for a card and put that card into your hand. Then shuffle.");
                                    effects.add(new SearchLibraryPutInHandEffect(new TargetCardInLibrary(new FilterCard("a card")), false));
                                    break;
                                }
                                case 13: {
                                    sb.append("Target player sacrifices two creatures.");
                                    effects.add(new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, 2, "Target player"));
                                    target = new TargetPlayer();
                                    break;
                                }
                                case 14: {
                                    sb.append("Create a 5/5 black Demon creature token with flying. You lose 2 life.");
                                    effects.add(new CreateTokenEffect((Token)new DemonToken()));
                                    effects.add(new LoseLifeSourceControllerEffect(2));
                                    break;
                                }
                                case 15: {
                                    sb.append("Create a 4/4 gold Dragon creature token with flying.");
                                    effects.add(new CreateTokenEffect((Token)new DragonTokenGold(), 1));
                                    break;
                                }
                                case 16: {
                                    sb.append("Target player's life total becomes 10.");
                                    effects.add(((Ability)new SorinMarkov(controller.getId(), this.setInfo).getAbilities().get(3)).getEffects().get(0));
                                    target = new TargetPlayer();
                                    break;
                                }
                                case 17: {
                                    sb.append("Destroy target nonland permanent.");
                                    effects.add(new DestroyTargetEffect());
                                    target = new TargetNonlandPermanent();
                                    break;
                                }
                                case 18: {
                                    sb.append("Return target permanent from a graveyard to the battlefield under your control.");
                                    effects.add(new ReturnFromGraveyardToBattlefieldTargetEffect());
                                    target = new TargetCardInGraveyard((FilterCard)new FilterPermanentCard());
                                    break;
                                }
                                case 19: {
                                    sb.append("Create two 3/3 green Beast creature tokens.");
                                    effects.add(new CreateTokenEffect((Token)new BeastToken(), 2));
                                    break;
                                }
                                case 20: {
                                    sb.append("Draw four cards and discard two cards.");
                                    effects.add(new DrawCardSourceControllerEffect(4));
                                    effects.add(new DiscardControllerEffect(2));
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (result) {
                                case 1: {
                                    sb.append("Urza deals 7 damage to target player. That player discards seven cards, then sacrifices seven permanents.");
                                    effects.add(new DamageTargetEffect(7));
                                    effects.add(new DiscardTargetEffect(7));
                                    effects.add(new SacrificeEffect(new FilterPermanent(), 7, "then"));
                                    target = new TargetPlayerOrPlaneswalker();
                                    break block0;
                                }
                                case 2: {
                                    sb.append("You get an emblem with \u201cIf a source would deal damage to you or a planeswalker you control, prevent all but 1 of that damage.\u201d");
                                    effects.add(new GetEmblemEffect((Emblem)new AjaniSteadfastEmblem()));
                                    break block0;
                                }
                                case 3: {
                                    sb.append("Destroy all lands target player controls.");
                                    effects.add(new DestroyAllControlledTargetEffect((FilterPermanent)new FilterLandPermanent()));
                                    target = new TargetPlayer();
                                    break block0;
                                }
                                case 4: {
                                    sb.append("Create X 2/2 white Cat creature tokens, where X is your life total.");
                                    effects.add(new CreateTokenEffect((Token)new CatToken(), (DynamicValue)ControllerLifeCount.instance));
                                    break block0;
                                }
                                case 5: {
                                    sb.append("You gain 100 life.");
                                    effects.add(new GainLifeEffect(100));
                                    break block0;
                                }
                                case 6: {
                                    sb.append("Urza deals 10 damage to target player and each creature they control.");
                                    effects.add(new DamageTargetEffect(10));
                                    effects.add(new DamageAllControlledTargetEffect(10));
                                    target = new TargetPlayerOrPlaneswalker();
                                    break block0;
                                }
                                case 7: {
                                    sb.append("You get an emblem with \u201cCreatures you control have double strike, trample, hexproof, and haste.\u201d");
                                    effects.add(new GetEmblemEffect((Emblem)new DomriRadeEmblem()));
                                    break block0;
                                }
                                case 8: {
                                    sb.append("You get an emblem with \u201cArtifacts, creatures, enchantments, and lands you control have indestructible.\u201d");
                                    effects.add(new GetEmblemEffect((Emblem)new ElspethKnightErrantEmblem()));
                                    break block0;
                                }
                                case 9: {
                                    sb.append("Create a 6/6 green Wurm creature token for each land you control.");
                                    effects.add(new CreateTokenEffect((Token)new WurmToken(), (DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledLandPermanent())));
                                    break block0;
                                }
                                case 10: {
                                    sb.append("Each player shuffles their hand and graveyard into their library. You draw seven cards.");
                                    effects.add(new ShuffleHandGraveyardAllEffect());
                                    effects.add(new DrawCardSourceControllerEffect(7));
                                    break block0;
                                }
                                case 11: {
                                    sb.append("Destroy up to three target creatures and/or other planeswalkers. Return each card put into a graveyard this way to the battlefield under your control.");
                                    effects.add(((Ability)new SorinLordOfInnistrad(controller.getId(), this.setInfo).getAbilities().get(4)).getEffects().get(0));
                                    target = new TargetPermanent(0, 3, filter4, false);
                                    break block0;
                                }
                                case 12: {
                                    sb.append("You get an emblem with \u201cWhenever you cast a spell, exile target permanent.\u201d");
                                    effects.add(new GetEmblemEffect((Emblem)new VenserTheSojournerEmblem()));
                                    break block0;
                                }
                                case 13: {
                                    sb.append("You get an emblem with \u201cWhenever a creature you control enters, you may have it fight target creature.\u201d Then create three 8/8 blue Octopus creature tokens.");
                                    effects.add(new CreateTokenEffect((Token)new OctopusToken(), 3));
                                    effects.add(new GetEmblemEffect((Emblem)new KioraMasterOfTheDepthsEmblem()));
                                    break block0;
                                }
                                case 14: {
                                    sb.append("You control target player during that player's next turn.");
                                    effects.add(new ControlTargetPlayerNextTurnEffect());
                                    target = new TargetPlayer();
                                    break block0;
                                }
                                case 15: {
                                    sb.append("Exile all cards from target player's library, then that player shuffles their hand into their library.");
                                    effects.add(((Ability)new JaceTheMindSculptor(controller.getId(), this.setInfo).getAbilities().get(5)).getEffects().get(0));
                                    target = new TargetPlayer();
                                    break block0;
                                }
                                case 16: {
                                    sb.append("Create three 1/1 black Assassin creature tokens with \u201cWhenever this creature deals combat damage to a player, that player loses the game.\u201d");
                                    effects.add(new CreateTokenEffect((Token)new AssassinToken()));
                                    break block0;
                                }
                                case 17: {
                                    sb.append("Put all creature cards from all graveyards onto the battlefield under your control.");
                                    effects.add(((Ability)new LilianaVess(controller.getId(), this.setInfo).getAbilities().get(4)).getEffects().get(0));
                                    break block0;
                                }
                                case 18: {
                                    sb.append("You gain X life and draw X cards, where X is the number of lands you control.");
                                    effects.add(new GainLifeEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledLandPermanent())));
                                    effects.add(new DrawCardSourceControllerEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledLandPermanent())));
                                    break block0;
                                }
                                case 19: {
                                    sb.append("Flip five coins. Take an extra turn after this one for each coin that comes up heads.");
                                    effects.add(((Ability)new RalZarek(controller.getId(), this.setInfo).getAbilities().get(4)).getEffects().get(0));
                                    break block0;
                                }
                                case 20: {
                                    sb.append("You gain 7 life, draw seven cards, then put up to seven permanent cards from your hand onto the battlefield.");
                                    effects.add((Object)new UginTheSpiritDragonEffect3());
                                }
                            }
                        }
                    }
                    game.informPlayers(sb.toString());
                    if (target == null) break block76;
                    if (target.canChoose(controller.getId(), source, game) && controller.canRespond()) break;
                    game.informPlayers("[URZA] Target can't be chosen, picking next ability...");
                    result = RandomUtil.nextInt((int)20) + 1;
                    effects.clear();
                    target = null;
                    sb = new StringBuilder("[URZA] ");
                }
                target.chooseTarget(this.outcome, controller.getId(), source, game);
                source.addTarget((Target)target);
            }
            if (target == null || target.isChosen(game)) {
                for (Effect effect : effects) {
                    if (effect instanceof ContinuousEffect) {
                        game.addEffect((ContinuousEffect)effect, source);
                        continue;
                    }
                    effect.apply(game, source);
                }
                return true;
            }
        }
        return false;
    }

    public UrzaAcademyHeadmasterRandomEffect copy() {
        return new UrzaAcademyHeadmasterRandomEffect(this);
    }

    static {
        filter1.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter2.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter3.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
        filter4.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

