/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class UvildaDeanOfPerfectionCastEffect
extends OneShotEffect {
    UvildaDeanOfPerfectionCastEffect() {
        super(Outcome.Benefit);
    }

    private UvildaDeanOfPerfectionCastEffect(UvildaDeanOfPerfectionCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public UvildaDeanOfPerfectionCastEffect copy() {
        return new UvildaDeanOfPerfectionCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (player == null || card == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Cast " + card.getName() + '?', source, game)) {
            return false;
        }
        SpellAbility spellAbility = player.chooseAbilityForCast(card, game, true);
        if (spellAbility == null) {
            return false;
        }
        CardUtil.reduceCost((Ability)spellAbility, (int)4);
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        player.cast(spellAbility, game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }
}

