/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.u.UvildaDeanOfPerfectionCastEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class UvildaDeanOfPerfectionTriggeredAbility
extends TriggeredAbilityImpl {
    UvildaDeanOfPerfectionTriggeredAbility() {
        super(Zone.EXILED, (Effect)new UvildaDeanOfPerfectionCastEffect());
    }

    private UvildaDeanOfPerfectionTriggeredAbility(UvildaDeanOfPerfectionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card = this.getSourceCardIfItStillExists(game);
        return event.getTargetId().equals(this.getSourceId()) && card != null && card.getCounters(game).getCount(CounterType.HONE) == 0 && event.getAmount() > 0 && event.getData().equals(CounterType.HONE.getName());
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getState().getZone(this.getSourceId()) == Zone.EXILED;
    }

    public UvildaDeanOfPerfectionTriggeredAbility copy() {
        return new UvildaDeanOfPerfectionTriggeredAbility(this);
    }

    public String getRule() {
        return "When the last hone counter is removed from this card, if it's exiled, you may cast it. It costs {4} less to cast this way.";
    }
}

