/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class DrawCardIfCreatureTypeAbility
extends TriggeredAbilityImpl {
    public DrawCardIfCreatureTypeAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
    }

    private DrawCardIfCreatureTypeAbility(DrawCardIfCreatureTypeAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DrawCardIfCreatureTypeAbility copy() {
        return new DrawCardIfCreatureTypeAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)this.getSourceId(), (Game)game);
        return subType != null && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isCreature(game) && spell.hasSubtype(subType, game) && spell.isControlledBy(this.getControllerId());
    }

    public String getRule() {
        return "Whenever you cast a creature spell of the chosen type, draw a card.";
    }
}

