/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ExileAllCardsFromAllGraveyards
extends OneShotEffect {
    public ExileAllCardsFromAllGraveyards() {
        super(Outcome.Benefit);
        this.staticText = "Exile all graveyards. Add {R}{R}{R}";
    }

    private ExileAllCardsFromAllGraveyards(ExileAllCardsFromAllGraveyards effect) {
        super((OneShotEffect)effect);
    }

    public ExileAllCardsFromAllGraveyards copy() {
        return new ExileAllCardsFromAllGraveyards(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject Tibalt = source.getSourceObject(game);
        LinkedHashSet cardsToExile = new LinkedHashSet();
        UUID exileId = CardUtil.getExileZoneId((String)source.getSourceId().toString(), (Game)game);
        if (controller != null && Tibalt != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                cardsToExile.addAll(player.getGraveyard().getCards(game));
            }
            controller.moveCardsToExile(cardsToExile, source, game, true, exileId, Tibalt.getName());
            controller.getManaPool().addMana(Mana.RedMana((int)3), game, source);
            return true;
        }
        return false;
    }
}

