/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Objects;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class VATSTarget
extends TargetPermanent {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creatures with equal toughness");

    VATSTarget() {
        super(0, Integer.MAX_VALUE, filter, false);
    }

    private VATSTarget(VATSTarget target) {
        super((TargetPermanent)target);
    }

    public VATSTarget copy() {
        return new VATSTarget(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Permanent creature = game.getPermanent(id);
        if (creature == null) return false;
        if (this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageObject::getToughness).mapToInt(MageInt::getValue).findFirst().orElse(0) != creature.getToughness().getValue()) return false;
        return true;
    }
}

