/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileUntilSourceLeavesEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ValkiGodOfLiesRevealExileEffect
extends OneShotEffect {
    ValkiGodOfLiesRevealExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent reveals their hand. For each opponent, exile a creature card they revealed this way until {this} leaves the battlefield.";
    }

    private ValkiGodOfLiesRevealExileEffect(ValkiGodOfLiesRevealExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValkiGodOfLiesRevealExileEffect copy() {
        return new ValkiGodOfLiesRevealExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet<Card> cardsToExile = new LinkedHashSet<Card>();
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Card targetedCardToExile;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getHand().isEmpty()) continue;
            opponent.revealCards(source, opponent.getHand(), game);
            TargetCard targetToExile = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            targetToExile.withChooseHint("card to exile");
            targetToExile.withNotTarget(true);
            if (!controller.choose(Outcome.Exile, opponent.getHand(), targetToExile, source, game) || (targetedCardToExile = game.getCard(targetToExile.getFirstTarget())) == null || game.getState().getZone(source.getSourceId()) != Zone.BATTLEFIELD) continue;
            cardsToExile.add(targetedCardToExile);
        }
        if (cardsToExile.isEmpty()) {
            return true;
        }
        ExileUntilSourceLeavesEffect effect = new ExileUntilSourceLeavesEffect(Zone.HAND);
        effect.setTargetPointer((TargetPointer)new FixedTargets(cardsToExile, game));
        return effect.apply(game, source);
    }
}

