/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapAllControllerEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.CastAsThoughItHadFlashAllEffect;
import mage.abilities.keyword.FlashAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;

public final class ValleyFloodcaller
extends CardImpl {
    private static final FilterCard nonCreatureFilter = new FilterCard("noncreature spells");
    private static final FilterCreaturePermanent creatureFilter = new FilterCreaturePermanent("Birds, Frogs, Otters, and Rats");

    public ValleyFloodcaller(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{U}");
        this.subtype.add((Object)SubType.OTTER);
        this.subtype.add((Object)SubType.WIZARD);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)FlashAbility.getInstance());
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CastAsThoughItHadFlashAllEffect(Duration.WhileOnBattlefield, nonCreatureFilter)));
        SpellCastControllerTriggeredAbility ability = new SpellCastControllerTriggeredAbility((Effect)new BoostControlledEffect(1, 1, Duration.EndOfTurn, (FilterPermanent)creatureFilter), StaticFilters.FILTER_SPELL_A_NON_CREATURE, false);
        ability.addEffect((Effect)new UntapAllControllerEffect((FilterPermanent)creatureFilter).setText("Untap them"));
        this.addAbility((Ability)ability);
    }

    private ValleyFloodcaller(ValleyFloodcaller card) {
        super((CardImpl)card);
    }

    public ValleyFloodcaller copy() {
        return new ValleyFloodcaller(this);
    }

    static {
        nonCreatureFilter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        creatureFilter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        creatureFilter.add(Predicates.or((Predicate[])new Predicate[]{SubType.BIRD.getPredicate(), SubType.FROG.getPredicate(), SubType.OTTER.getPredicate(), SubType.RAT.getPredicate()}));
    }
}

