/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class ValorousStance
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with toughness 4 or greater");

    public ValorousStance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{W}");
        GainAbilityTargetEffect gainAbilityEffect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
        gainAbilityEffect.setOutcome(Outcome.Benefit);
        this.getSpellAbility().addEffect((Effect)gainAbilityEffect);
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        Mode mode1 = new Mode((Effect)new DestroyTargetEffect());
        mode1.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getSpellAbility().addMode(mode1);
    }

    private ValorousStance(ValorousStance card) {
        super((CardImpl)card);
    }

    public ValorousStance copy() {
        return new ValorousStance(this);
    }

    static {
        filter.add((Predicate)new ToughnessPredicate(ComparisonType.MORE_THAN, 3));
    }
}

