/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VanishIntoMemoryEntersBattlefieldEffect
extends ReplacementEffectImpl {
    VanishIntoMemoryEntersBattlefieldEffect() {
        super(Duration.EndOfTurn, Outcome.Discard);
        this.staticText = "discard cards equal to that creature's toughness.";
    }

    private VanishIntoMemoryEntersBattlefieldEffect(VanishIntoMemoryEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(event.getTargetId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player you;
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent != null && (you = game.getPlayer(source.getControllerId())) != null) {
            you.discard(permanent.getToughness().getValue(), false, false, source, game);
        }
        return false;
    }

    public VanishIntoMemoryEntersBattlefieldEffect copy() {
        return new VanishIntoMemoryEntersBattlefieldEffect(this);
    }
}

