/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.cards.v.VastwoodAnimistElementalToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.Token;

class VastwoodAnimistEffect
extends OneShotEffect {
    static final FilterControlledPermanent filterAllies = new FilterControlledPermanent("allies you control");

    public VastwoodAnimistEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target land you control becomes an X/X Elemental creature until end of turn, where X is the number of Allies you control. It's still a land.";
    }

    private VastwoodAnimistEffect(VastwoodAnimistEffect effect) {
        super((OneShotEffect)effect);
    }

    public VastwoodAnimistEffect copy() {
        return new VastwoodAnimistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = new PermanentsOnBattlefieldCount((FilterPermanent)filterAllies).calculate(game, source, (Effect)this);
        BecomesCreatureTargetEffect effect = new BecomesCreatureTargetEffect((Token)new VastwoodAnimistElementalToken(amount), false, true, Duration.EndOfTurn);
        effect.setTargetPointer(this.getTargetPointer().copy());
        game.addEffect((ContinuousEffect)effect, source);
        return false;
    }

    static {
        filterAllies.add((Predicate)SubType.ALLY.getPredicate());
    }
}

