/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.v.Vault11VotersDilemmaVote;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class Vault11VotersDilemmaEffect
extends OneShotEffect {
    Vault11VotersDilemmaEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for up to one creature, then those votes are revealed. If no creature got votes, each player draws a card. Otherwise, destroy each creature with the most votes or tied for most votes";
    }

    private Vault11VotersDilemmaEffect(Vault11VotersDilemmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public Vault11VotersDilemmaEffect copy() {
        return new Vault11VotersDilemmaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Vault11VotersDilemmaVote vote = new Vault11VotersDilemmaVote();
        vote.doVotes(source, game);
        Set mostVoted = vote.getMostVoted();
        mostVoted.removeIf(Objects::isNull);
        if (!mostVoted.isEmpty()) {
            for (Permanent permanent : mostVoted) {
                permanent.destroy(source, game);
            }
            return true;
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Optional.ofNullable(game.getPlayer(playerId)).map(player -> player.drawCards(1, source, game));
        }
        return true;
    }
}

