/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class Vault21HouseGambitEffect
extends OneShotEffect {
    Vault21HouseGambitEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal up to five nonland cards from your hand. For each of those cards that has the same mana value as another card revealed this way, create a Treasure token";
    }

    private Vault21HouseGambitEffect(Vault21HouseGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public Vault21HouseGambitEffect copy() {
        return new Vault21HouseGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 5, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        if (cards.isEmpty()) {
            return false;
        }
        player.revealCards(source, (Cards)cards, game);
        int count = cards.getCards(game).stream().map(MageObject::getManaValue).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum)).values().stream().mapToInt(x -> x > 1 ? x : 0).sum();
        return count > 0 && new TreasureToken().putOntoBattlefield(count, game, source);
    }
}

