/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.common.TreasureSpentToCastCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility
extends TriggeredAbilityImpl {
    VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.addTarget((Target)new TargetCreaturePermanent());
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy(", then"));
        this.setTriggerPhrase("Whenever an opponent casts a spell or activates an ability, if mana from a Treasure was spent to cast it or activate it, ");
    }

    private VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility(VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        Player caster = game.getPlayer(event.getPlayerId());
        if (controller == null || caster == null || !game.getOpponents(controller.getId()).contains(caster.getId())) {
            return false;
        }
        Ability ability = game.getStack().getStackObject(event.getTargetId()).getStackAbility();
        return TreasureSpentToCastCondition.instance.apply(game, ability);
    }

    public VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility copy() {
        return new VaziKeenNegotiatorOpponentCastsOrActivatesTriggeredAbility(this);
    }
}

