/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VectisDominatorEffect
extends OneShotEffect {
    protected Cost cost;

    public VectisDominatorEffect(Cost cost) {
        super(Outcome.Detriment);
        this.staticText = "Tap target creature unless its controller pays 2 life";
        this.cost = cost;
    }

    private VectisDominatorEffect(VectisDominatorEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public VectisDominatorEffect copy() {
        return new VectisDominatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null && (player = game.getPlayer(targetCreature.getControllerId())) != null) {
            this.cost.clearPaid();
            String question = "Pay 2 life? (Otherwise " + targetCreature.getName() + " will be tapped)";
            if (player.chooseUse(Outcome.Benefit, question, source, game)) {
                this.cost.pay(source, game, source, targetCreature.getControllerId(), true, null);
            }
            if (!this.cost.isPaid()) {
                return targetCreature.tap(source, game);
            }
        }
        return false;
    }
}

