/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class VeiledSentryEffect
extends ContinuousEffectImpl {
    private int spellMV = 0;

    public VeiledSentryEffect() {
        super(Duration.Custom, Outcome.BecomeCreature);
        this.staticText = "{this} becomes an Illusion creature with power and toughness each equal to that spell's mana value";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private VeiledSentryEffect(VeiledSentryEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.spellMV = effect.spellMV;
    }

    public VeiledSentryEffect copy() {
        return new VeiledSentryEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell != null) {
            this.spellMV = spell.getManaValue();
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.removeAllSubTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.addSubType(game, new SubType[]{SubType.ILLUSION});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(this.spellMV);
                permanent.getToughness().setModifiedBaseValue(this.spellMV);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

