/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.LevelUpAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VeneratedTeacherEffect
extends OneShotEffect {
    VeneratedTeacherEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put two level counters on each creature you control with level up";
    }

    private VeneratedTeacherEffect(VeneratedTeacherEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), game);
        if (!permanents.isEmpty()) {
            for (Permanent permanent : permanents) {
                for (Ability ability : permanent.getAbilities()) {
                    if (!(ability instanceof LevelUpAbility)) continue;
                    permanent.addCounters(CounterType.LEVEL.createInstance(2), source.getControllerId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public VeneratedTeacherEffect copy() {
        return new VeneratedTeacherEffect(this);
    }
}

