/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class VentureForthEffect
extends OneShotEffect {
    VentureForthEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a land card. Put that card onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private VentureForthEffect(VentureForthEffect effect) {
        super((OneShotEffect)effect);
    }

    public VentureForthEffect copy() {
        return new VentureForthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) {
                player.moveCards(card, Zone.BATTLEFIELD, source, game);
                break;
            }
            cards.add(card);
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

