/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyApplier;

class VesuvanDoppelgangerCopyEffect
extends OneShotEffect {
    VesuvanDoppelgangerCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "have this creature become a copy of target creature, except it doesn't copy that creature's color and it has this ability";
    }

    private VesuvanDoppelgangerCopyEffect(VesuvanDoppelgangerCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        final Permanent sourcePermanent = permanent;
        if (controller != null && sourcePermanent != null) {
            TargetPermanent target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent("target creature (you copy from)"));
            target.setRequired(true);
            if (source instanceof SimpleStaticAbility) {
                target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent("creature (you copy from)"));
                target.setRequired(false);
                target.withNotTarget(true);
            }
            if (target.canChoose(source.getControllerId(), source, game)) {
                controller.choose(Outcome.Copy, (Target)target, source, game);
                Permanent copyFromPermanent = game.getPermanent(target.getFirstTarget());
                if (copyFromPermanent != null) {
                    game.copyPermanent(copyFromPermanent, sourcePermanent.getId(), source, new CopyApplier(){

                        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
                            blueprint.getColor().setColor(sourcePermanent.getColor(game));
                            blueprint.getAbilities().add((Object)new BeginningOfUpkeepTriggeredAbility(TargetController.YOU, (Effect)new VesuvanDoppelgangerCopyEffect(), true));
                            return true;
                        }
                    });
                    return true;
                }
            }
        }
        return false;
    }

    public VesuvanDoppelgangerCopyEffect copy() {
        return new VesuvanDoppelgangerCopyEffect(this);
    }
}

