/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapAttachedCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.v.VeteransVoiceAdjuster;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;

public final class VeteransVoice
extends CardImpl {
    private static final FilterPermanent filterUntapped = new FilterCreaturePermanent("enchanted creature is untapped");
    private static final Condition condition;

    public VeteransVoice(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetControlledCreaturePermanent auraTarget = new TargetControlledCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new ActivateIfConditionActivatedAbility((Effect)new BoostTargetEffect(2, 1, Duration.EndOfTurn).setText("target creature other than the creature tapped this way gets +2/+1 until end of turn"), (Cost)new TapAttachedCost(), condition).setTargetAdjuster((TargetAdjuster)VeteransVoiceAdjuster.instance));
    }

    private VeteransVoice(VeteransVoice card) {
        super((CardImpl)card);
    }

    public VeteransVoice copy() {
        return new VeteransVoice(this);
    }

    static {
        filterUntapped.add((Predicate)TappedPredicate.UNTAPPED);
        condition = new AttachedToMatchesFilterCondition(filterUntapped);
    }
}

