/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VexEffect
extends OneShotEffect {
    VexEffect() {
        super(Outcome.Neutral);
        this.staticText = "Counter target spell. That spell's controller may draw a card";
    }

    private VexEffect(VexEffect effect) {
        super((OneShotEffect)effect);
    }

    public VexEffect copy() {
        return new VexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        Player controller = null;
        boolean countered = false;
        if (targetId != null) {
            controller = game.getPlayer(game.getControllerId(targetId));
        }
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            countered = true;
        }
        if (controller != null) {
            controller.drawCards(1, source, game);
        }
        return countered;
    }
}

